function test_suite = testCtranspose %#ok<STOUT>
initTestSuite;

function ctwarn = setup %#ok<*DEFNU>
% Clear warnings and suppress the display of the warning by CTRANSPOSE.
lastwarn('');
ctwarn = 'polysym:ctranspose:noConjugate';
warning('off',ctwarn)

function testEmpty(ctwarn)
p = polysym.empty;
q = p';
[~,msgid] = lastwarn;
assertTrue(isempty(q))
assertEqual(msgid,ctwarn)

function testDefault(ctwarn)
p = polysym;
q = p';
[~,msgid] = lastwarn;
assertEqual(p,q.')
assertEqual(msgid,ctwarn)

function testNumeric(ctwarn)
% The only difference between ctranspose (') and transpose (.') is that the
% former gives a warning.
p = polysym(randi(100,3));
q = p';
[~,msgid] = lastwarn;
assertEqual(p,q.')
assertEqual(msgid,ctwarn)

function teardown(ctwarn)
warning('on',ctwarn)